/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc.model
{
	import com.techlabs.puremvc.ApplicationFacade;
	import com.techlabs.puremvc.model.business.LoadXMLDelegate;
	import com.techlabs.puremvc.model.helpers.SharedObjectActions;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	
	import org.puremvc.as3.interfaces.IProxy;
	import org.puremvc.as3.patterns.proxy.Proxy;

	public class DataProxy extends Proxy implements IProxy, IResponder
	{
		public static const NAME:String = "DataProxy";
		
		[Bindable]
		public var feeds:ArrayCollection;
		
		
		
		public function DataProxy( data:Object=null)
		{
			super(NAME, data);
			//check if a shared object already exists
			if(SharedObjectActions.getLocalSOData('rssFeeds') == null)
				feeds = new ArrayCollection();
			else
				feeds = SharedObjectActions.getLocalSOData('rssFeeds') as ArrayCollection;
		}
		
		public function saveData():void
		{
			SharedObjectActions.saveToLocalSO('rssFeeds',feeds);
		}
		
		public function loadFeed(url:String):void
		{
			var delegate : LoadXMLDelegate = new LoadXMLDelegate(this, url);
			// make the delegate do some work
			delegate.load();
		
		}
		
		public function result(data:Object):void
		{
			//parse the data.
			var xml:XML = new XML(data.result);
			var postList:XMLList = xml..item;
			sendNotification(ApplicationFacade.LOADING_FEED_COMPLETE, postList);
		}
		
		public function fault(info:Object):void
		{
			
		}
		
	}
}